import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LineHeightIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-line-height",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 8l3 -3l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 16l3 3l3 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 5l0 14"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 6l7 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 12l7 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 18l7 0"
    }, null), _createTextVNode(" ")]);
  }
};