import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LoadBalancerIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-load-balancer",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 13m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 10v-7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 6l3 -3l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 10v-7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 6l3 -3l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.894 12.227l6.11 -2.224"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.159 8.21l3.845 1.793l-1.793 3.845"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.101 12.214l-6.075 -2.211"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.871 8.21l-3.845 1.793l1.793 3.845"
    }, null), _createTextVNode(" ")]);
  }
};