import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'LogicNandIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-logic-nand",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22 12h-3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 9h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 15h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 5c6 0 8 3.5 8 7s-2 7 -8 7h-2v-14h2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode(" ")]);
  }
};