import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MarqueeOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-marquee-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 6c0 -.556 .227 -1.059 .593 -1.421"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 4h1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.5 4h1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 4a2 2 0 0 1 2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 9v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 13.5v1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.402 19.426a1.993 1.993 0 0 1 -1.402 .574"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 20h-1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.5 20h-1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 20a2 2 0 0 1 -2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 15v-1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 10.5v-1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};