import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MasksTheaterIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-masks-theater",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.192 9h6.616a2 2 0 0 1 1.992 2.183l-.567 6.182a4 4 0 0 1 -3.983 3.635h-1.5a4 4 0 0 1 -3.983 -3.635l-.567 -6.182a2 2 0 0 1 1.992 -2.183z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 13h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 13h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 16.5c1 .667 2 .667 3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.632 15.982a4.037 4.037 0 0 1 -.382 .018h-1.5a4 4 0 0 1 -3.983 -3.635l-.567 -6.182a2 2 0 0 1 1.992 -2.183h6.616a2 2 0 0 1 2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 8h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 8h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 12c.764 -.51 1.528 -.63 2.291 -.36"
    }, null), _createTextVNode(" ")]);
  }
};