import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MathSymbolsIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-math-symbols",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 12l18 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3l0 18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16.5 4.5l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.5 4.5l-3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 4l0 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 6l4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 16l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 20l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 18l4 0"
    }, null), _createTextVNode(" ")]);
  }
};