import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MessageSearchIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-message-search",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 9h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 13h5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.008 19.195l-3.008 1.805v-3h-2a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.2 20.2l1.8 1.8"
    }, null), _createTextVNode(" ")]);
  }
};