import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MicroscopeIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-microscope",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 21h14"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 18h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 18v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 11l3 3l6 -6l-3 -3z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.5 12.5l-1.5 1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 3l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21a6 6 0 0 0 3.715 -10.712"
    }, null), _createTextVNode(" ")]);
  }
};