import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MoodBoyIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-mood-boy",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 4.5a9 9 0 0 1 3.864 5.89a2.5 2.5 0 0 1 -.29 4.36a9 9 0 0 1 -17.137 0a2.5 2.5 0 0 1 -.29 -4.36a9 9 0 0 1 3.746 -5.81"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 16a3.5 3.5 0 0 0 5 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.5 2c1.5 1 2.5 3.5 2.5 5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.5 2c1.5 2 2 3.5 2 5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 12l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 12l.01 0"
    }, null), _createTextVNode(" ")]);
  }
};