import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MoodEditIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-mood-edit",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.955 11.104a9 9 0 1 0 -9.895 9.847"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 10h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 10h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 15c.658 .672 1.56 1 2.5 1c.126 0 .251 -.006 .376 -.018"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z"
    }, null), _createTextVNode(" ")]);
  }
};