import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'MoodUpIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-mood-up",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.984 12.536a9 9 0 1 0 -8.463 8.449"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 22v-6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22 19l-3 -3l-3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 10h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 10h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 15c.658 .64 1.56 1 2.5 1s1.842 -.36 2.5 -1"
    }, null), _createTextVNode(" ")]);
  }
};