import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'Multiplier05xIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-multiplier-0-5x",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 16h2a2 2 0 1 0 0 -4h-2v-4h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 16v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 16l4 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 16l-4 -4"
    }, null), _createTextVNode(" ")]);
  }
};