import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'NetworkIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-network",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 9m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3c1.333 .333 2 2.333 2 6s-.667 5.667 -2 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3c-1.333 .333 -2 2.333 -2 6s.667 5.667 2 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 9h12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 19h7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 19h7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15v2"
    }, null), _createTextVNode(" ")]);
  }
};