import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'NewsOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-news-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 6h3a1 1 0 0 1 1 1v9m-.606 3.435a2 2 0 0 1 -3.394 -1.435v-2m0 -4v-7a1 1 0 0 0 -1 -1h-7m-3.735 .321a1 1 0 0 0 -.265 .679v12a3 3 0 0 0 3 3h11"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 12h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 16h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};