import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'PlayFootballIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-play-football",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 4a1 1 0 1 0 2 0a1 1 0 0 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 17l5 1l.75 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 21v-4l-4 -3l1 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 12v-3l5 -1l3 3l3 1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.5 20a.5 .5 0 1 0 0 -1a.5 .5 0 0 0 0 1z",
      "fill": "currentColor"
    }, null), _createTextVNode(" ")]);
  }
};