import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'PlayHandballIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-play-handball",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 21l3.5 -2l-4.5 -4l2 -4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 6l2 4l5 .5l4 2.5l2.5 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 20l5 -1l1.5 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 7a1 1 0 1 0 2 0a1 1 0 0 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.5 5a.5 .5 0 1 0 0 -1a.5 .5 0 0 0 0 1z",
      "fill": "currentColor"
    }, null), _createTextVNode(" ")]);
  }
};