import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'PlayVolleyballIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-play-volleyball",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 4a1 1 0 1 0 2 0a1 1 0 0 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.5 10a.5 .5 0 1 0 0 -1a.5 .5 0 0 0 0 1z",
      "fill": "currentColor"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 16l5 1l.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.5 21l2.5 -5.5l-5.5 -3.5l3.5 -4l3 4l4 2"
    }, null), _createTextVNode(" ")]);
  }
};