import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'PlugConnectedIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-plug-connected",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 12l5 5l-1.5 1.5a3.536 3.536 0 1 1 -5 -5l1.5 -1.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 12l-5 -5l1.5 -1.5a3.536 3.536 0 1 1 5 5l-1.5 1.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 21l2.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.5 5.5l2.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 11l-2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 14l-2 2"
    }, null), _createTextVNode(" ")]);
  }
};