import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'PresentationAnalyticsIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-presentation-analytics",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 12v-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 12v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 4h18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 4v10a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 20h6"
    }, null), _createTextVNode(" ")]);
  }
};