import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ProgressAlertIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-progress-alert",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 20.777a8.942 8.942 0 0 1 -2.48 -.969"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 3.223a9.003 9.003 0 0 1 0 17.554"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.579 17.093a8.961 8.961 0 0 1 -1.227 -2.592"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.124 10.5c.16 -.95 .468 -1.85 .9 -2.675l.169 -.305"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.907 4.579a8.954 8.954 0 0 1 3.093 -1.356"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16v.01"
    }, null), _createTextVNode(" ")]);
  }
};