import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'RegexIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-regex",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.5 15a2.5 2.5 0 1 1 0 5a2.5 2.5 0 0 1 0 -5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7.875l3 -1.687"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7.875v3.375"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7.875l-3 -1.687"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7.875l3 1.688"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 4.5v3.375"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7.875l-3 1.688"
    }, null), _createTextVNode(" ")]);
  }
};