import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ReportIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-report",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h5.697"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 14v4h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 11v-4a2 2 0 0 0 -2 -2h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 11h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 15h3"
    }, null), _createTextVNode(" ")]);
  }
};