import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'RollercoasterIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-rollercoaster",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 21a5.55 5.55 0 0 0 5.265 -3.795l.735 -2.205a8.775 8.775 0 0 1 8.325 -6h3.675"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 9v12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21v-3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21v-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 9.5v11.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 3h5v3h-5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 8l4 -3l2 2.5l-4 3l-1.8 -.5z"
    }, null), _createTextVNode(" ")]);
  }
};