import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'RollercoasterOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-rollercoaster-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 21a5.55 5.55 0 0 0 5.265 -3.795l.735 -2.205a8.759 8.759 0 0 1 2.35 -3.652m2.403 -1.589a8.76 8.76 0 0 1 3.572 -.759h3.675"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 9v7m0 4v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21v-3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21v-9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 9.5v2.5m0 4v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 3h5v3h-5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.446 5.415l.554 -.415l2 2.5l-.285 .213m-2.268 1.702l-1.447 1.085l-1.8 -.5l-.2 -2l1.139 -.854"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};