import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ScaleOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-scale-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 20h10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.452 5.425l2.548 -.425l6 1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v5m0 4v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 12l-3 -6l-3 6a3 3 0 0 0 6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.873 14.871a3 3 0 0 0 2.127 -2.871l-3 -6l-2.677 5.355"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};