import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SchemaOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-schema-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 2h4v4m-4 0h-1v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 11v-1h5v4h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 18h5v4h-5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 10h5v4h-5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 12h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7.5 7.5v2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7.5 14v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};