import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ScreenshotIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-screenshot",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 19a2 2 0 0 1 -2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 13v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 7a2 2 0 0 1 2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 5h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 5a2 2 0 0 1 2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 11v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 17v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 19h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 19h-2"
    }, null), _createTextVNode(" ")]);
  }
};