import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ShareOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-share-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 6m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.861 15.896a3 3 0 0 0 4.265 4.22m.578 -3.417a3.012 3.012 0 0 0 -1.507 -1.45"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.7 10.7l1.336 -.688m2.624 -1.352l2.64 -1.36"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.7 13.3l6.6 3.4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};