import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SkullIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-skull",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 4c4.418 0 8 3.358 8 7.5c0 1.901 -.755 3.637 -2 4.96l0 2.54a1 1 0 0 1 -1 1h-10a1 1 0 0 1 -1 -1v-2.54c-1.245 -1.322 -2 -3.058 -2 -4.96c0 -4.142 3.582 -7.5 8 -7.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 17v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 17v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 11m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 11m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode(" ")]);
  }
};