import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SlideshowIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-slideshow",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 6l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 13l4 -4a3 5 0 0 1 3 0l4 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 12l2 -2a3 5 0 0 1 3 0l3 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21l.01 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 21l.01 0"
    }, null), _createTextVNode(" ")]);
  }
};