import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SnowflakeOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-snowflake-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 4l2 1l2 -1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 2v6m1.196 1.186l1.804 1.034"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.928 6.268l.134 2.232l1.866 1.232"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.66 7l-5.629 3.25l-.031 .75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.928 14.268l-1.015 .67"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.212 14.226l-2.171 1.262"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 20l-2 -1l-2 1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 22v-6.5l-3 -1.72"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.072 17.732l-.134 -2.232l-1.866 -1.232"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.34 17l5.629 -3.25l-.01 -3.458"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.072 9.732l1.866 -1.232l.134 -2.232"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.34 7l5.629 3.25l.802 -.466"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};