import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SnowmanIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-snowman",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3a4 4 0 0 1 2.906 6.75a6 6 0 1 1 -5.81 0a4 4 0 0 1 2.904 -6.75z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.5 11.5l2.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.5 11.5l-2.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 13h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16h.01"
    }, null), _createTextVNode(" ")]);
  }
};