import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SolarPanel2Icon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-solar-panel-2",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 2a4 4 0 1 0 8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 3h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 3h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 9v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.2 7.2l.707 .707"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.8 7.2l-.7 .7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.28 21h15.44a1 1 0 0 0 .97 -1.243l-1.5 -6a1 1 0 0 0 -.97 -.757h-12.44a1 1 0 0 0 -.97 .757l-1.5 6a1 1 0 0 0 .97 1.243z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 17h16"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 13l-1 8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 13l1 8"
    }, null), _createTextVNode(" ")]);
  }
};