import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SolarPanelIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-solar-panel",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.28 14h15.44a1 1 0 0 0 .97 -1.243l-1.5 -6a1 1 0 0 0 -.97 -.757h-12.44a1 1 0 0 0 -.97 .757l-1.5 6a1 1 0 0 0 .97 1.243z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 10h16"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 6l-1 8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 6l1 8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 14v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 18h10"
    }, null), _createTextVNode(" ")]);
  }
};