import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SpiderIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-spider",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 4v2l5 5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2.5 9.5l1.5 1.5h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 19v-2l6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 4v2l-5 5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21.5 9.5l-1.5 1.5h-6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 19v-2l-6 -6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
    }, null), _createTextVNode(" ")]);
  }
};