import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SunHighIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-sun-high",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.828 14.828a4 4 0 1 0 -5.656 -5.656a4 4 0 0 0 5.656 5.656z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.343 17.657l-1.414 1.414"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.343 6.343l-1.414 -1.414"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.657 6.343l1.414 -1.414"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.657 17.657l1.414 1.414"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 12h-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 4v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 12h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20v2"
    }, null), _createTextVNode(" ")]);
  }
};