import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SunWindIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-sun-wind",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.468 10a4 4 0 1 0 -5.466 5.46"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 12h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 3v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 20v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.6 5.6l.7 .7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.4 5.6l-.7 .7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.3 17.7l-.7 .7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 13h5a2 2 0 1 0 0 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16h5.714l.253 0a2 2 0 0 1 2.033 2a2 2 0 0 1 -2 2h-.286"
    }, null), _createTextVNode(" ")]);
  }
};