import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SunglassesIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-sunglasses",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 4h-2l-3 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 4h2l3 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 16h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 16.5a3.5 3.5 0 0 1 -7 0v-2.5h7v2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 14l4.5 4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 14l4.5 4.5"
    }, null), _createTextVNode(" ")]);
  }
};