import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'Sunset2Icon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-sunset-2",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 13h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 13h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.6 6.6l.7 .7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.4 6.6l-.7 .7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 13a4 4 0 1 1 8 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 17h18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 20h5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 20h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 5v-1"
    }, null), _createTextVNode(" ")]);
  }
};