import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'SwordsIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-swords",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 3v5l-11 9l-4 4l-3 -3l4 -4l9 -11z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 13l6 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.32 17.32l3.68 3.68l3 -3l-3.365 -3.365"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 5.5l-2 -2.5h-5v5l3 2.5"
    }, null), _createTextVNode(" ")]);
  }
};