import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TexIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-tex",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 8v-1h-6v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 15v-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 15l-5 -8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 15l5 -8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 11h-4v8h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 15h3"
    }, null), _createTextVNode(" ")]);
  }
};