import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ThermometerIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-thermometer",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 5a2.828 2.828 0 0 1 0 4l-8 8h-4v-4l8 -8a2.828 2.828 0 0 1 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 7l-1.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 10l-1.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 13l-1.5 -1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 17l-3 3"
    }, null), _createTextVNode(" ")]);
  }
};