import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ThreedCubeSphereOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-3d-cube-sphere-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 17.6l-2 -1.1v-2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 10v-2.5l2 -1.1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 4.1l2 -1.1l2 1.1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 6.4l2 1.1v2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 14v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 19.9l-2 1.1l-2 -1.1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 8.6l2 -1.1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12v2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 18.5v2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12l-2 -1.12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 8.6l-2 -1.1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};