import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ToiletPaperOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-toilet-paper-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.27 4.28c-.768 1.27 -1.27 3.359 -1.27 5.72c0 3.866 1.343 7 3 7s3 -3.134 3 -7c0 -.34 -.01 -.672 -.03 -1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 10c0 -3.866 -1.343 -7 -3 -7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 3h11"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 10v7m-1.513 2.496l-1.487 -.496l-3 2l-3 -3l-3 2v-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 10h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};