import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ToolsKitchenIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-tools-kitchen",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 3h8l-1 9h-6z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 18h2v3h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 3v12h-5c-.023 -3.681 .184 -7.406 5 -12z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 15v6h-1v-3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 12l0 6"
    }, null), _createTextVNode(" ")]);
  }
};