import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ToolsKitchenOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-tools-kitchen-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 3h5l-.5 4.5m-.4 3.595l-.1 .905h-6l-.875 -7.874"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 18h2v3h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.225 11.216c.42 -2.518 1.589 -5.177 4.775 -8.216v12h-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 15v1m0 4v1h-1v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 12v6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};