import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ToolsOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-tools-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 12l4 -4a2.828 2.828 0 1 0 -4 -4l-4 4m-2 2l-7 7v4h4l7 -7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.5 5.5l4 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8l-5 -5m-2 2l-2 2l5 5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 8l-1.5 1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 12l5 5m-2 2l-2 2l-5 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 17l-1.5 1.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};