import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TopologyRing3Icon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-topology-ring-3",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 8v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 16v-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 6h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 18h-8"
    }, null), _createTextVNode(" ")]);
  }
};