import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TopologyStarRing3Icon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-topology-star-ring-3",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 19a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 5a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 5a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 19a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M22 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 12h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 12h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 7l-2 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 7l2 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 14l-2 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 14l2 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 5h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 19h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 17l2 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 10l-2 -3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 7l-2 3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 14l2 3"
    }, null), _createTextVNode(" ")]);
  }
};