import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'TrainIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-train",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 13c0 -3.87 -3.37 -7 -10 -7h-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 15h16a2 2 0 0 0 2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 6v5h17.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 10l0 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 11l0 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 11l0 -4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 19l18 0"
    }, null), _createTextVNode(" ")]);
  }
};